'use strict';

/* Controllers */
var CreatorCtrl = ['$scope', '$rootScope', '$location', function($scope, $rootScope, $location){
    var stepSelected = 1;
    var myPlayer = _V_("creator_notary");

    $scope.steps = [
        {id: 1, name: 'Nazwa spółki', active: true, cssClass: ''},
        {id: 2, name: 'Struktura władz spółki', active: false, cssClass: ''},
        {id: 3, name: 'Forma reprezentacji', active: false, cssClass: ''},
        {id: 4, name: 'Zakres działania', active: false, cssClass: ''}
    ]

    $scope.stepPoints = [
        {id: 1, left: 4.7, start: 1, end: 1.3},
        {id: 2, left: 6.7, start: 4, end: 4.3},
        {id: 3, left: 19.7, start: 6, end: 6.3},
        {id: 4, left: 39.7, start: 9, end: 9.3}
    ]

    $scope.stepModel = {
        1: {id: 1, name: ''},
        2: {id: 2, memberNumber: 0, chef: ''},
        3: {id: 3, requireNumber: 0},
        4: {id: 4, codesPKD: ''}
    }


    $scope.addCuepointForVideojs = function(){
        videojs("creator_notary").ready(function(){
            var $this = this;
            $this.cuepoints();
            angular.forEach($scope.stepPoints, function(point){
                $this.addCuepoint({
                    namespace: "logger",
                    start: point.start,
                    end: point.end,
                    onStart: function(params){
                        if(params.error){
                        }else{
                            myPlayer.pause();
                            $('.panel').show();
                        }
                    },
                    onEnd: function(params){
                        myPlayer.play();
                        $('.panel').hide();
                        stepSelected++;
                    },
                    params: {error: false}
                });
            })
        });
    }

    $scope.submit = function(){
        myPlayer.play();
        $('.panel').hide();
        stepSelected++;
        console.log($scope.stepModel,stepSelected);
        console.log(myPlayer.currentTime());

    }

    $scope.showPanel = function($id){
        return ($id == stepSelected);
    }

}]